VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CIngresoCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public TransID As Long
Public Fecha As Date
Public Hora As Date
Public Sesion As Long
Public Operador As String
Public TipoDocRel As String     ' ISDOC: TipoEntidad
Public NumeroDocRel As Long     ' ISDOC
Public TipoEntidad As String    ' ISPC: TipoEntidad
Public CodigoEntidad As String  ' ISPC
Public Descripcion As String
Public Debitos As Currency, _
       Creditos As Currency

Public CerrarCredito As Boolean   ' Solicita que el cierre se procese como credito (compatible con clrCaja5)
Public HayDescuento As Boolean    ' Notifica que el cierre produjo un descuento.
Public Vuelto As Currency

' La interfaz (que no sabe nada del contexto) devuelve la informacion correspondiente a los medios de pago
' recibidos.
Public colDetalles As Collection  ' of CDetalleIngreso, que a su vez pueden contener o o mas CDetalleDenominacion

Public Sub LoadInstance(rs As Recordset, Optional Dest As CIngresoCaja = Nothing)
Dim pDest As CIngresoCaja
  Set pDest = Dest
  If pDest Is Nothing Then Set pDest = Me
  With pDest
  .TransID = GetNumeroFromVariant(rs(0))
  .Fecha = GetDateFromVariant(rs(2))
  .Hora = GetDateFromVariant(rs(11))
  .Sesion = GetNumeroFromVariant(rs(1))
  .Operador = GetStringFromVariant(rs(3))
  .TipoDocRel = GetStringFromVariant(rs(8))
  .NumeroDocRel = GetNumeroFromVariant(rs(9))
  .TipoEntidad = GetStringFromVariant(rs(6))
  .CodigoEntidad = GetStringFromVariant(rs(7))
  .Descripcion = GetStringFromVariant(rs(10))
  .Debitos = GetNumeroFromVariant(rs(4))
  .Creditos = GetNumeroFromVariant(rs(5))
  End With
End Sub

Public Function Load(iTransID As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean
  Set rs = dbHandle.Execute("SELECT * FROM MovimientosCaja WHERE TransID = " & NumeroDB(iTransID))
  If rs.EOF Then
    bRetVal = False
  Else
    bRetVal = True
    LoadInstance rs
  End If
  rs.Close
  Load = bRetVal
End Function

Public Function Numero() As Long
  Numero = Me.TransID
End Function

Public Function Detalles() As Collection  ' De DetallesDenominacion
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT * FROM DetallesIngresoCaja WHERE TransID = " & NumeroDB(Me.TransID) & " ORDER BY Id")
  Dim retCol As New Collection, pDet As CDetalleIngreso
  Do While Not rs.EOF
    Set pDet = New CDetalleIngreso
    pDet.LoadInstance rs
    retCol.Add pDet
    rs.MoveNext
  Loop
  rs.Close: Set rs = Nothing
  Set Detalles = retCol
End Function

Public Function NombreEntidadRelacionada() As String
Dim p As Object, pInst As Object
Dim sRetVal As String

  If Factoria Is Nothing Then
    sRetVal = "NombreEntidadRelacionada NO DISPONIBLE"
  Else
    Set pInst = Factoria.CrearObjeto("Instanciador")
    Set p = pInst.Entidad(TipoEntidad, CodigoEntidad)
    If p Is Nothing Then
      sRetVal = "NombreEntidadRelacionada NO LOCALIZADO"
    Else
      sRetVal = p.Nombre
      Set p = Nothing
    End If
    Set pInst = Nothing
  End If
  NombreEntidadRelacionada = sRetVal

End Function

Private Function ValorClase(X As ClaseIngresoSesion) As Currency
Dim Detalle As CDetalleIngreso, Medio As CMedioPago, acum As Currency
  For Each Detalle In Me.Detalles
    Set Medio = MedioPago(Detalle.Medio)
    If Medio.Clase = X Then acum = acum + Detalle.Monto
  Next
  Set Medio = Nothing
  ValorClase = acum
End Function

Public Property Get Efectivo() As Currency
  Efectivo = ValorClase(ClaseIngresoSesion.Efectivo)
End Property

Public Property Get TCVisa() As Currency
  TCVisa = ValorClase(TTCVisa)
End Property

Public Property Get TCMaster() As Currency
  TCMaster = ValorClase(TTCMaster)
End Property

Public Property Get TCAmex() As Currency
  TCAmex = ValorClase(TTCAmex)
End Property

Public Property Get Cheques() As Currency
  Cheques = ValorClase(ClaseIngresoSesion.Cheques)
End Property

Public Property Get OtrasTC() As Currency
  OtrasTC = ValorClase(TTCOtras)
End Property

Public Property Get TDebito() As Currency
  TDebito = ValorClase(ClaseIngresoSesion.TDebito)
End Property

Public Property Get OtrosMedios() As Currency
  OtrosMedios = ValorClase(ClaseIngresoSesion.OtrosMedios)
End Property

Public Sub Save(iSesion As Long, iOperador As String, iTipoDoc As String, iNumeroDoc As Long, iTipoEntidad As String, _
  iCodigoEntidad As String, iDescripcion As String, iFecha As Date, Optional Handle As Connection = Nothing)
Dim s As String, Valor As Currency
  If Not Handle Is Nothing Then Set dbHandle = Handle
  With Me
    If .TransID <> 0 Then
      Err.Raise 5, "CIngresoCaja::Save", "Intento de guardar movimiento de caja duplicado"
      Exit Sub
    End If
    .CodigoEntidad = iCodigoEntidad
    .Descripcion = iDescripcion
    .NumeroDocRel = iNumeroDoc
    .Operador = iOperador
    .Sesion = iSesion
    .TipoDocRel = iTipoDoc
    .TipoEntidad = iTipoEntidad
  End With
  Me.Hora = CDate(Now - Date)
  s = "INSERT INTO MovimientosCaja (Fecha, Hora, Sesion, Operador, TipoDocumento, NumeroDocumento, TipoEntidad, CodigoEntidad, Descripcion, Debitos, Creditos) VALUES ("
  s = s & FechaDB(iFecha) & ", " & TimeDateDB(Now) & ", " & NumeroDB(iSesion) & ", " & StringDB(iOperador) & ", "
  s = s & StringDB(iTipoDoc) & ", " & NumeroDB(iNumeroDoc) & ", " & StringDB(iTipoEntidad) & ", " & StringDB(iCodigoEntidad) & ", "
  s = s & StringDB(iDescripcion) & ", " & NumeroDB(Debitos) & ", " & NumeroDB(Creditos) & ");"
  
  dbHandle.Execute s
  
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT @@IDENTITY")
  Me.TransID = rs(0)
  rs.Close
  
  Dim pDet As CDetalleIngreso
  For Each pDet In colDetalles
    AddDetalleS pDet
  Next

End Sub

Public Function LoadFromDocumento(sTipoDoc As String, lNumeroDoc As Long) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

  sQuery = "SELECT * FROM MovimientosCaja WHERE TipoDocumento = " & StringDB(sTipoDoc) & " AND NumeroDocumento = " & NumeroDB(lNumeroDoc) & ";"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    rs.Close
    sQuery = "SELECT M.* " & _
             "FROM MovimientosCaja AS M, subDocsMC AS S " & _
             "WHERE s.TipoDoc = " & StringDB(sTipoDoc) & " " & _
             "AND s.numDoc = " & NumeroDB(lNumeroDoc) & " " & _
             "AND M.TransID = S.TransID " & _
             "AND S.ID IN " & _
             "  (SELECT MAX(ID) FROM subDocsMC WHERE TipoDoc = " & StringDB(sTipoDoc) & " " & _
             "AND NumDoc = " & NumeroDB(lNumeroDoc) & ");"
    Set rs = dbHandle.Execute(sQuery)
  End If
  
  If rs.EOF Then
    bRetVal = False
  Else
    bRetVal = True
    LoadInstance rs
  End If

  If Not rs Is Nothing Then
    rs.Close
  End If
  Set rs = Nothing
  LoadFromDocumento = bRetVal
End Function

Public Function AddDetalle(iCodigoMedio As String, iMonto As Currency, iIdTitular As String, iNumeroCuenta As String, iNumeroDoc As String, _
  iClaveAutorizacion As String, iCodigoEmisor As String, iMontoNominal As Currency, iDetalles As Collection) As Long
Dim s As String
  s = "INSERT INTO DetallesIngresoCaja (TransID, Medio, Monto, IdTitular, NumeroCuenta, NumeroDocumento, ClaveAutorizacion, Emisor, MontoNominal) VALUES ("
  s = s & NumeroDB(Me.TransID) & ", " & StringDB(iCodigoMedio) & ", " & NumeroDB(iMonto) & ", " & StringDB(iIdTitular) & ", "
  s = s & StringDB(iNumeroCuenta) & ", " & StringDB(iNumeroDoc) & ", " & StringDB(iClaveAutorizacion) & ", "
  s = s & StringDB(iCodigoEmisor) & ", " & NumeroDB(iMontoNominal) & ");"
  dbHandle.Execute s
  Dim rs As Recordset, l As Long
  Set rs = dbHandle.Execute("SELECT @@IDENTITY")
  l = rs(0)
  rs.Close
  If Not iDetalles Is Nothing Then
    Dim detDenom As CDetalleDenominacion
    For Each detDenom In iDetalles
      s = "INSERT INTO DetallesDenominacion (idDetalle, Denominacion, CantidadRecibida) VALUES ("
      s = s & NumeroDB(l) & ", " & NumeroDB(detDenom.Denominacion) & ", " & NumeroDB(detDenom.CantidadRecibida) & ");"
      dbHandle.Execute s
    Next
  End If
  AddDetalle = l
End Function

Public Sub AddDetalleS(pDetalle As CDetalleIngreso)
  With pDetalle
    .Id = AddDetalle(.Medio, .Monto, .IdTitular, .NumeroCuenta, .NumeroDocumento, .ClaveAutorizacion, .CodigoEmisor, .MontoNominal, .Denominaciones)
  End With
End Sub

'---------------------------------------------------------------------------------------
' Function AddConcepto
' Fecha/Hora: 27/03/03 10:24
' Funcin   : Los movimientos (ingresos) relacionados con varios documentos tienen
'             <TipoDocumento> en vbNullString y <NumeroDocumento> en 0.
'             Para poder establecer una relacin entre un movimiento de caja y varios
'             documentos, se agregan hoy los Conceptos, que establecen una relacin de
'             n<->n entre los documentos ISPC y los ingresos de caja.
'             Esta relacin se constituye en la clase CDocsMovCaja
'---------------------------------------------------------------------------------------
'
Public Function AddConcepto(vmDebitos As Currency, vmCreditos As Currency, TipoDoc As String, numDoc As Long) As Boolean
Dim sQuery As String, bRetVal As Boolean

  bRetVal = True
  sQuery = "INSERT INTO SubDocsMC (TransID, TipoDoc, NumDoc, Debitos, Creditos) VALUES ("
  sQuery = sQuery & NumeroDB(Me.TransID) & ", "
  sQuery = sQuery & StringDB(TipoDoc) & ", "
  sQuery = sQuery & NumeroDB(numDoc) & ", "
  sQuery = sQuery & NumeroDB(vmDebitos) & ", "
  sQuery = sQuery & NumeroDB(vmCreditos) & ");"
  dbHandle.Execute sQuery

  AddConcepto = bRetVal

End Function

'---------------------------------------------------------------------------------------
' Function Conceptos
' Fecha/Hora: 27/03/03 10:41
' Funcin   : Devuelve los subconceptos asociados con un movimiento de caja.
'             si el movimiento no tiene subconceptos, devuelve los datos base del
'             propio movimiento.
'---------------------------------------------------------------------------------------
'
Public Function Conceptos() As Collection
Dim sQuery As String, rs As Recordset, retCol As Collection, pConcepto As CDocsMovCaja
  
  On Error GoTo ErrHandler
  sQuery = "SELECT * FROM subDocsMC WHERE TransID = " & NumeroDB(Me.TransID) & " ORDER BY ID"
  Set rs = dbHandle.Execute(sQuery)
  Set retCol = New Collection
  Do While Not rs.EOF
    Set pConcepto = New CDocsMovCaja
    With pConcepto
    .Creditos = GetNumeroFromVariant(rs.Fields("Creditos"))
    .Debitos = GetNumeroFromVariant(rs.Fields("Debitos"))
    .NumeroDoc = GetNumeroFromVariant(rs.Fields("NumDoc"))
    .TipoDoc = GetStringFromVariant(rs.Fields("TipoDoc"))
    .TransID = GetNumeroFromVariant(rs.Fields("TransID"))
    End With
    retCol.Add pConcepto
    rs.MoveNext
  Loop

  If retCol.Count = 0 Then
    Set pConcepto = New CDocsMovCaja
    With pConcepto
    .Creditos = Me.Creditos
    .Debitos = Me.Debitos
    .NumeroDoc = Me.NumeroDocRel
    .TipoDoc = Me.TipoDocRel
    .TransID = Me.TransID
    End With
    retCol.Add pConcepto
  End If
    
ResumePoint:
  Set pConcepto = Nothing
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  Set Conceptos = retCol
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description

  ReportarError False, ErrN, ErrD, "CMovimientoCaja::Conceptos"
  Set retCol = Nothing
  Resume ResumePoint

End Function


Private Sub Class_Initialize()
  Set colDetalles = New Collection
End Sub

Private Sub Class_Terminate()
  Set colDetalles = Nothing
End Sub
